using System.Net.Sockets;
using System.Reflection;
using System.Text;
using System.Xml.Linq;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.Menu;

namespace KoAla_Next_K {
 public partial class Form1 : Form {
  bool dragDown = false;
  bool dragLeft = false;
  bool activated = false;
  public Form1() {
   InitializeComponent();
   InitializeWebView();
   pnlDown.Height = 30;
   pnlDown.Top = this.Height - 30;
   webView.Height = this.Height - 30;
   //this.Width=900;
   webViewDown.Top = pnlDown.Height;
   webViewDown.Width = this.Width;
   webViewDown.Height = this.Height - 15;

   pnlGuide.Top = 0;
   pnlGuide.Left = 0;
   pnlGuide.Width = this.Width;
   pnlGuide.Height = this.Height;

   //webViewGuide.Dock = DockStyle.Bottom;
   webViewGuide.Top = 0;
   webViewGuide.Left = 0;
   webViewGuide.Width = this.Width - 30;
   webViewGuide.Height = this.Height;


  }

  private async void InitializeWebView() {
   await webView.EnsureCoreWebView2Async(null);
   await webViewGuide.EnsureCoreWebView2Async(null);
   webView.CoreWebView2.Navigate("https://www.gonet.tv/onlinetv/?lang=pl#1");

   webView.CoreWebView2.DOMContentLoaded += (s, e) => {
    tmrInit.Enabled = true;
    activated = true;

   };

  }

  private void Form1_Load(object sender, EventArgs e) { }

  private void tmrInit_Tick(object sender, EventArgs e) {
   cssJs();
  }

  private void tmrLoop_Tick(object sender, EventArgs e) {

  }

  private void Form1_Activated(object sender, EventArgs e) {
   if(activated) {
    cssJs();
   }
  }

  public async void cssJs() {
   string css = @"
           *{display:none !important;
            }
            *:has(.prehled_item), .prehled_item {
              display:block !important;
            }
            .prehled_item *{
            display:block !important;
            }
            ";
   css = @"
            div{
            border-radius:0px !important;
            -webkit-mask-image:unset !important;
            }
            .top_menu_header, .ctrls-navTime, .prehled_item_rating, .station_item_buttons{
            display:none !important;
            }
            .station {
            top: 0px !important;
            padding-top: 0px !important;
            }
            .prehled_item_progress {
            height: 0.5em;
            }
            .prehled_item_inner{
            height:70%;
            }
            .global_elipsis2 > div {
            display: block;
            }
            .global_elipsis2 {
            word-break: normal;
            overflow-wrap: break-word;
            hyphens: auto;
            white-space: normal !important;
            }
           .global_elipsis2 > div {
               font-size: 1.333em;
               max-height: 2.666em;
           }





.prehled_item_img{
display:none;
}

.prehled_item{
margin-bottom: 10px !important;
width: 165px !important;
height: 135px !important;
}
.prehled_item_left_stanice{
width:100%;
height:100%;
}
.prehled_item_left_stanice img{
background-color: rgba(0, 0, 0, 0.5);
padding: 5px;
width: 90% !important;
height: 70%;
object-fit: contain;
transform: translate(-50%, -50%);
margin-top: 25%;
margin-left: 50%;
}
            ";

   string jsCode = $@"
            


if(document.getElementsByClassName('screensaver_bg')[0] || document.getElementById('home') ){{//||  document.getElementById('epg')
            //if(!home.clickBlock)layout_home.TvShow();home.clickBlock=false;
            layout_home.TvShow();home.clickBlock=false;
            const style = document.createElement('style');
            style.textContent = `{css}`;
            document.head.appendChild(style);
            epg.SetSelected('stations');
            station.ShowGroup('skupina-vse', true);
            window.chrome.webview.postMessage(""domloaded"");
}}

function addLongClick(el, delay = 1000) {{
 let timer;
 el.addEventListener(""mousedown"", (event) => {{
  timer = setTimeout(() => {{
   event.stopPropagation();
   event.preventDefault();
   let title = el.getAttribute(""title"");
   if (title) {{
    title=title.replace(/\s+/g, '-');
    title=title.replace(/(\S)(\d+)/g, '$1-$2')
    title=title.replace(/-+/g, '-');
    title=title.replace(""Puls-2"", ""tv-puls-2"");
    //alert(""Dugi klik na elemencie: "" + title);
    window.chrome.webview.postMessage(""Guide "" + title);
   }}
  }}, delay);
 }});
 el.addEventListener(""mouseup"", () => clearTimeout(timer));
 el.addEventListener(""mouseleave"", () => clearTimeout(timer));
}}
document.querySelectorAll('[role=""gridcell""]').forEach(cell => {{
 addLongClick(cell);
}});

document.querySelectorAll('div[role=""gridcell""]').forEach(div => {{
const onclickAttr = div.getAttribute(""onclick"");
if (onclickAttr) {{
 const match = onclickAttr.match(/station\.ClickStation\((\d+),\s*'(\d+)'\)/);
 if (match) {{
  const number = match[1]; // wycignita liczba
  div.removeAttribute(""onclick"");
  div.onclick = function() {{
   window.chrome.webview.postMessage(number);

   }};
  }}
 }}
}});
            ";
   await webView.ExecuteScriptAsync(jsCode);

  }


  private void webView_WebMessageReceived(object sender, Microsoft.Web.WebView2.Core.CoreWebView2WebMessageReceivedEventArgs e) {
   webViewDown.Source = new Uri("https://climate.pl/12186/owczarnia-2/14-days");
   string channel = e.TryGetWebMessageAsString();
   //MessageBox.Show("Otrzymano tekst: " + tekst);
   if(channel == "domloaded") {
    //tmrInit.Enabled = false;
   } else if(channel.StartsWith("Guide ")) {
    webViewGuide.Source = new Uri("https://telemagazyn.pl/stacje/" + channel.Substring("Guide ".Length));
    pnlGuide.Visible = true;
    pnlGuide.Left = 0;
    cssJsGuide();
   } else {
    try {
     // Poczenie z serwerem na localhost:5000
     TcpClient client = new TcpClient("10.0.0.4", 5000);

     NetworkStream stream = client.GetStream();

     // Wysyanie wiadomoci
     byte[] data = Encoding.UTF8.GetBytes(channel);
     stream.Write(data, 0, data.Length);

     // Odbir odpowiedzi
     byte[] buffer = new byte[1024];
     int bytesRead = stream.Read(buffer, 0, buffer.Length);
     string response = Encoding.UTF8.GetString(buffer, 0, bytesRead);

     txtLog.Text = response;

     client.Close();
    }
    catch(Exception ex) {
     txtLog.Text = "Bd klienta: " + ex.Message;
    }
   }
  }

  private async void pnlDown_MouseDown(object sender, MouseEventArgs e) {
   dragDown = true;
   string css = $@"
@media (max-width: 670px) {{
    .overall-basic {{
    display: block !important;
    }}
   .weather-detail-desktop {{
    all:unset;
    }}
}}
header, footer, .layout-up, .weather-data, .weather-region, .weather-info, .banner-inner, .weather-regions-list, .weather-detail-mobile, .layout-main__sidebar, .menu-info, .weather-detail__scale, .weather-detail-mobile{{
display:none !important;
}}
div{{
background-image:none !important;
}}
*{{
box-shadow:none !important;
}}
.layout-main, .layout-main__content{{
width:100% !important;
}}
.weather-detail__main-right{{
flex:unset !important;
width:100%;
}}
html {{filter: invert(1) hue-rotate(180deg);overflow:hidden;
}}
";
   string jsCode = $@"
const style = document.createElement('style');
style.textContent = `{css}`;
document.head.appendChild(style);

";
   await webViewDown.ExecuteScriptAsync(jsCode);
  }

  private void pnlDown_MouseUp(object sender, MouseEventArgs e) {
   dragDown = false;
   if(pnlDown.Height > this.Height / 2) {
    pnlDown.Height = this.Height;
   } else {
    pnlDown.Height = 30;
   }
  }

  private void pnlDown_MouseMove(object sender, MouseEventArgs e) {
   // webViewDown.Top = pnlDown.Height + 30;
   if(dragDown == true) {
    Point pos = this.PointToClient(Cursor.Position);
    pnlDown.Height = Math.Max(this.Height - pos.Y, 30);
   }
  }

  public async void cssJsGuide() {
   string css = $@"
.js-emissionCompleted, .js-sticky-nav, .layoutsGrid__top medium-full,.componentsNavigationNavbar, aside, footer, .atomsAdsCellModel, .atomsTvChannelEmissionTile__promotedContainer, .atomsTvPartialsDescription{{
display:none !important;
}}
body{{padding: 0px !important}}
.atomsTvChannelHeader{{border:0 !important;}}
#didomi-popup, #didomi-popup * {{display: none !important;}}
html {{filter: invert(1); }}
img, .atomsPartialLabelLabelFill, .js-showProgressBar, .atomsTvChannelEmissionTile__episode-value,  .atomsTvChannelEmissionTile__season-value, .componentsTvChannelTvGuide__progressBarLabel {{filter: invert(1) !important;}}
a {{pointer-events: none;cursor: default;}}
body.didomi-popup-open{{overflow:scroll !important}}
picture, picture img{{width:100px !important;}}
img{{border: 5px solid white;background-color: white;}}
body::-webkit-scrollbar {{display: none;}}
";
   string jsCode = $@"
const style = document.createElement('style');
style.textContent = `{css}`;
document.head.appendChild(style);
var count=0;
countInterval=setInterval(function () {{count++;document.body.setAttribute(""style"", ""overflow:scroll !important;"");if(count>3000){{clearInterval(countInterval)}}}}, 1);
";
   await webViewGuide.ExecuteScriptAsync(jsCode);
  }

  private void pnlGuide_MouseDown(object sender, MouseEventArgs e) {
   dragLeft = true;
   cssJsGuide();
  }

  private void pnlGuide_MouseMove(object sender, MouseEventArgs e) {
   if(dragLeft == true) {
    Point pos = this.PointToClient(Cursor.Position);
    pnlGuide.Left = -this.Width + pos.X; //Math.Max(this.Width - pos.X, 30);
   }
  }

  private void pnlGuide_MouseUp(object sender, MouseEventArgs e) {
   dragLeft = false;
   if(pnlGuide.Left < -this.Width / 2) {
    pnlGuide.Left = -this.Width;
   } else {
    pnlGuide.Left = 0;
   }
  }
 }
}

